#
# Unusual variables checked by this code:
#	CONSTRUCTING - if non empty, generate the global ctor and dtor tables.
#	DATA_ADDR - if end-of-text-plus-one-page isn't right for data start
#	DATA_START_SYMBOLS - symbols that appear at the start of the
#		.data section.
#	ELFSIZE - Size of an ELF word (?)
#	EXECUTABLE_SYMBOLS - symbols that must be defined for an
#		executable (e.g., _DYNAMIC_LINK)
#	INITIAL_READONLY_SECTIONS - at start of text segment
#	NOP - two byte opcode for no-op (defaults to 0)
#	OTHER_BSS_SYMBOLS - symbols that appear at the start of the
#		.bss section besides __bss_start.
#	OTHER_GOT_SECTIONS - sections just after .got and .sdata.
#	OTHER_GOT_SYMBOLS - symbols defined just before .got.
#	OTHER_READONLY_SECTIONS - other than .text .init .rodata ...
#		(e.g., .PARISC.milli)
#	OTHER_READWRITE_SECTIONS - other than .data .bss .ctors .sdata ...
#		(e.g., .PARISC.global)
#	OTHER_SECTIONS - at the end
#	OTHER_TEXT_SECTIONS - these get put in .text when relocating
#	TEXT_START_SYMBOLS - symbols that appear at the start of the
#		.text section.
#	DATA_PLT - .plt should be in data segment, not text segment.
#
# WRS specific variables
#	WRS_PAGESIZE - size of a page. The text, data, rodata sections are
#                      aligned on this page size.
#
# When adding sections, do note that the names of some sections are used
# when specifying the start address of the next.
#

test -z "$ENTRY" && ENTRY=_start
test -z "${BIG_OUTPUT_FORMAT}" && BIG_OUTPUT_FORMAT=${OUTPUT_FORMAT}
test -z "${LITTLE_OUTPUT_FORMAT}" && LITTLE_OUTPUT_FORMAT=${OUTPUT_FORMAT}
if [ -z "$MACHINE" ]; then OUTPUT_ARCH=${ARCH}; else OUTPUT_ARCH=${ARCH}:${MACHINE}; fi
test -z "${ELFSIZE}" && ELFSIZE=32
test -z "${ALIGNMENT}" && ALIGNMENT="${ELFSIZE} / 8"
test "$LD_FLAG" = "N" && DATA_ADDR=.
INTERP=".interp   ${RELOCATING-0} : { *(.interp) 	}"
PLT_T=".plt    ${RELOCATING-0} : { *(.plt)	}"
PLT_D="*(.plt)"
DYNAMIC_T=".dynamic     ${RELOCATING-0} : { *(.dynamic) }"
DYNAMIC_D="*(.dynamic)"
CTOR="/* BEGIN .ctors */
    ${CONSTRUCTING+${CTOR_START}}
    /* gcc uses crtbegin.o to find the start of
       the constructors, so we make sure it is
       first.  Because this is a wildcard, it
       doesn't matter if the user does not
       actually link against crtbegin.o; the
       linker won't look for a file to match a
       wildcard.  The wildcard also means that it
       doesn't matter which directory crtbegin.o
       is in.  */

    KEEP (*crtbegin.o(.ctors))

    /* We don't want to include the .ctor section
       from the crtend.o file until after the sorted ctors.
       The .ctor section from the crtend file contains the
       end of ctors marker and it must be last */

    KEEP (*(EXCLUDE_FILE (*crtend.o) .ctors))
    KEEP (*(SORT(.ctors.*)))
    KEEP (*(.ctors))
    ${CONSTRUCTING+${CTOR_END}}
    /* END   .ctors */"

DTOR="/* BEGIN .dtors */
    ${CONSTRUCTING+${DTOR_START}}
    KEEP (*crtbegin.o(.dtors))
    KEEP (*(EXCLUDE_FILE (*crtend.o) .dtors))
    KEEP (*(SORT(.dtors.*)))
    KEEP (*(.dtors))
    ${CONSTRUCTING+${DTOR_END}}
    /* END   .dtors */"

# if this is for an embedded system, don't add SIZEOF_HEADERS.
if [ -z "$EMBEDDED" ]; then
   test -z "${TEXT_BASE_ADDRESS}" && TEXT_BASE_ADDRESS="${TEXT_START_ADDR} + SIZEOF_HEADERS"
else
   test -z "${TEXT_BASE_ADDRESS}" && TEXT_BASE_ADDRESS="${TEXT_START_ADDR}"
fi

cat <<EOF

OUTPUT_FORMAT("${OUTPUT_FORMAT}", "${BIG_OUTPUT_FORMAT}",
	      "${LITTLE_OUTPUT_FORMAT}")
OUTPUT_ARCH(${OUTPUT_ARCH})
ENTRY(${ENTRY})

${RELOCATING+${LIB_SEARCH_DIRS}}
${RELOCATING+${EXECUTABLE_SYMBOLS}}
${RELOCATING- /* For some reason, the Solaris linker makes bad executables
  if gld -r is used and the intermediate file has sections starting
  at non-zero addresses.  Could be a Solaris ld bug, could be a GNU ld
  bug.  But for now assigning the zero vmas works.  */}

/* Program headers are not generated by the linker for the moment.
PHDRS
{
  text		PT_LOAD	FLAGS(5) ;	@* read-execute *@
  rodata	PT_LOAD	FLAGS(4) ;	@* read *@
  data_bss	PT_LOAD	FLAGS(6) ;	@* read-write *@
  dde		PT_LOAD	FLAGS(0x8000) ;	@* domain description *@
}
*/

SECTIONS
{
  ${INTERP}
  ${INITIAL_READONLY_SECTIONS}
  ${TEXT_DYNAMIC+${DYNAMIC_T}}
  .hash        ${RELOCATING-0} : { *(.hash)		}
  .dynsym      ${RELOCATING-0} : { *(.dynsym)		}
  .dynstr      ${RELOCATING-0} : { *(.dynstr)		}
  .gnu.version ${RELOCATING-0} : { *(.gnu.version)	}
  .gnu.version_d ${RELOCATING-0} : { *(.gnu.version_d)	}
  .gnu.version_r ${RELOCATING-0} : { *(.gnu.version_r)	}

  .rel.init    ${RELOCATING-0} : { *(.rel.init)	}
  .rela.init   ${RELOCATING-0} : { *(.rela.init)	}
  .rel.text    ${RELOCATING-0} :
    {
      *(.rel.text)
      ${RELOCATING+*(.rel.text.*)}
      ${RELOCATING+*(.rel.gnu.linkonce.t*)}
    }
  .rela.text   ${RELOCATING-0} :
    {
      *(.rela.text)
      ${RELOCATING+*(.rela.text.*)}
      ${RELOCATING+*(.rela.gnu.linkonce.t*)}
    }
  .rel.fini    ${RELOCATING-0} : { *(.rel.fini)	}
  .rela.fini   ${RELOCATING-0} : { *(.rela.fini)	}
  .rel.rodata  ${RELOCATING-0} :
    {
      *(.rel.rodata)
      ${RELOCATING+*(.rel.rodata.*)}
      ${RELOCATING+*(.rel.gnu.linkonce.r*)}
    }
  .rela.rodata ${RELOCATING-0} :
    {
      *(.rela.rodata)
      ${RELOCATING+*(.rela.rodata.*)}
      ${RELOCATING+*(.rela.gnu.linkonce.r*)}
    }
  ${OTHER_READONLY_RELOC_SECTIONS}
  .rel.data    ${RELOCATING-0} :
    {
      *(.rel.data)
      ${RELOCATING+*(.rel.data.*)}
      ${RELOCATING+*(.rel.gnu.linkonce.d*)}
    }
  .rela.data   ${RELOCATING-0} :
    {
      *(.rela.data)
      ${RELOCATING+*(.rela.data.*)}
      ${RELOCATING+*(.rela.gnu.linkonce.d*)}
    }
  .rel.ctors   ${RELOCATING-0} : { *(.rel.ctors)	}
  .rela.ctors  ${RELOCATING-0} : { *(.rela.ctors)	}
  .rel.dtors   ${RELOCATING-0} : { *(.rel.dtors)	}
  .rela.dtors  ${RELOCATING-0} : { *(.rela.dtors)	}
  .rel.got     ${RELOCATING-0} : { *(.rel.got)		}
  .rela.got    ${RELOCATING-0} : { *(.rela.got)		}
  ${OTHER_GOT_RELOC_SECTIONS}
  .rel.bss     ${RELOCATING-0} : { *(.rel.bss)		}
  .rela.bss    ${RELOCATING-0} : { *(.rela.bss)		}
  .rel.plt     ${RELOCATING-0} : { *(.rel.plt)		}
  .rela.plt    ${RELOCATING-0} : { *(.rela.plt)		}

  .init        ${RELOCATING-0} : { KEEP (*(.init))	} =${NOP-0}
  ${DATA_PLT-${PLT_T}}
  .vx.linkage.table ${RELOCATING-0}${RELOCATING+BLOCK($WRS_PAGESIZE)} :
  {
    *(.vx.linkage.table)
  }
  .vx.unmapped.linkage.table ${RELOCATING-0}${RELOCATING+BLOCK($WRS_PAGESIZE)} :
  {
    *(.vx.unmapped.linkage.table)
  }
  .text    ${RELOCATING-0}${RELOCATING+BLOCK(${WRS_PAGESIZE})} :
  {
    ${RELOCATING+${TEXT_START_SYMBOLS}}
    *(.prefab_header)
    *(.text)
    ${RELOCATING+*(.text.*)}
    *(.stub)
    /* .gnu.warning sections are handled specially by elf32.em.  */
    *(.gnu.warning)
    ${RELOCATING+*(.gnu.linkonce.t*)}
    ${RELOCATING+${OTHER_TEXT_SECTIONS}}
  } =${NOP-0}
  .fini    ${RELOCATING-0} : { KEEP (*(.fini))		} =${NOP-0}
  ${RELOCATING+${OTHER_READONLY_SECTIONS}}
  .rodata ${RELOCATING-0}${RELOCATING+BLOCK($WRS_PAGESIZE)} :
  {
    *(.rodata)
    ${RELOCATING+*(.rodata.*)}
    ${RELOCATING+*(.gnu.linkonce.r*)}
    /* .rodata1 used to be its own section, but our use of AT,ADDR,SIZEOF are
       such that we can't have an optional section appearing just before etext
       (ADDR and SIZEOF of a section with no contents causes an error). If the
       linker is improved to handle that gracefully, then we can use a more
       normal-looking section map that preserves the identity of optionals. */
    ${RELOCATING+*(.rodata1)}
    ${RELOCATING+. = ALIGN(${ALIGNMENT});}
  }
  ${RELOCATING+. = ALIGN(${ALIGNMENT});}
  ${RELOCATING+_etext = .;}
  ${RELOCATING+PROVIDE (etext = .);}

  .data  ${RELOCATING-0} : AT ( _etext )
  {
    ${RELOCATING+${DATA_START_SYMBOLS}}
    *(.data)
    ${RELOCATING+*(.data.*)}
    ${RELOCATING+*(.gnu.linkonce.d*)}
    ${CONSTRUCTING+SORT(CONSTRUCTORS)}
    /* Input sections after this point used to be in separate sections, however
       many of these sections are optional and that fouls up the cascaded use
       of AT ( LOADADDR (.previous) + SIZEOF (.previous) ) which was how we
       first implemented this. If anyone depends on these sections retaining
       their independent identities, then we will have to rethink this and
       maybe enhance the linker to handle the situation more gracefully. */
    ${RELOCATING+*(.data1)}
    ${RELOCATING+*(.eh_frame)}
    ${RELOCATING+*(.gcc_except_table)}
    /* FIXME! We put OTHER_READWRITE_SECTIONS _inside_ a section, not outside
       as it normally is, because of the AT/SIZEOF/LOADADDR issue discussed
       above. This means that if any of our emulations supply these, they must
       use a different convention from everyone else. Currently, none do. */
    ${RELOCATING+${OTHER_READWRITE_SECTIONS}}
    ${RELOCATING+${CTOR}}
    ${RELOCATING+${DTOR}}
    ${DATA_PLT+${PLT_D}}
    ${RELOCATING+${OTHER_GOT_SYMBOLS}}
    *(.got.plt) *(.got)
    ${TEXT_DYNAMIC-${DYNAMIC_D}}
    /* Currently on vxWorks we do not support sdata/sbss, but if someone tries
       to use them, make sure they get put in sane places and not piled at the
       end of the memory map, where they will be useless to a ROM image. */
    *(.sdata) *(.sdata.*)
    /* FIXME! We put OTHER_GOT_SECTIONS _inside_ a section, not outside
       as it normally is, because of the AT/SIZEOF/LOADADDR issue discussed
       above. This means that vxr6ebmip.sh has to use a unique convention. */
    ${RELOCATING+${OTHER_GOT_SECTIONS}}
    ${RELOCATING+. = ALIGN(${ALIGNMENT});}
  }
  ${RELOCATING+. = ALIGN(${ALIGNMENT});}
  ${RELOCATING+_edata = .;}
  ${RELOCATING+PROVIDE (edata = .);}
  ${RELOCATING+__bss_start = .;}
  ${RELOCATING+${OTHER_BSS_SYMBOLS}}
  .bss     ${RELOCATING-0} :
  {
   *(.sbss) *(.scommon)
   *(.dynbss)
   *(.bss)
   *(COMMON)
   /* Align here to ensure that the .bss section occupies space up to
      _end.  Align after .bss to ensure correct alignment even if the
      .bss section disappears because there are no input sections.  */
   ${RELOCATING+. = ALIGN(${ALIGNMENT});}
  }
  ${RELOCATING+. = ALIGN(${ALIGNMENT});}
  ${RELOCATING+_end = .;}
  ${RELOCATING+${OTHER_BSS_END_SYMBOLS}}
  ${RELOCATING+PROVIDE (end = .);}

  /* The WRS domain description section */

  .vx.domain.table : { *(.vx.domain.table) }

  /* Stabs debugging sections.  */
  .stab 0 : { *(.stab) }
  .stabstr 0 : { *(.stabstr) }
  .stab.excl 0 : { *(.stab.excl) }
  .stab.exclstr 0 : { *(.stab.exclstr) }
  .stab.index 0 : { *(.stab.index) }
  .stab.indexstr 0 : { *(.stab.indexstr) }

  .comment 0 : { *(.comment) }

  /* DWARF debug sections.
     Symbols in the DWARF debugging sections are relative to the beginning
     of the section so we begin them at 0.  */

  /* DWARF 1 */
  .debug          0 : { *(.debug) }
  .line           0 : { *(.line) }

  /* GNU DWARF 1 extensions */
  .debug_srcinfo  0 : { *(.debug_srcinfo) }
  .debug_sfnames  0 : { *(.debug_sfnames) }

  /* DWARF 1.1 and DWARF 2 */
  .debug_aranges  0 : { *(.debug_aranges) }
  .debug_pubnames 0 : { *(.debug_pubnames) }

  /* DWARF 2 */
  .debug_info     0 : { *(.debug_info) }
  .debug_abbrev   0 : { *(.debug_abbrev) }
  .debug_line     0 : { *(.debug_line) }
  .debug_frame    0 : { *(.debug_frame) }
  .debug_str      0 : { *(.debug_str) }
  .debug_loc      0 : { *(.debug_loc) }
  .debug_macinfo  0 : { *(.debug_macinfo) }

  /* SGI/MIPS DWARF 2 extensions */
  .debug_weaknames 0 : { *(.debug_weaknames) }
  .debug_funcnames 0 : { *(.debug_funcnames) }
  .debug_typenames 0 : { *(.debug_typenames) }
  .debug_varnames  0 : { *(.debug_varnames) }

  ${RELOCATING+${OTHER_RELOCATING_SECTIONS}}

  /* These must appear regardless of ${RELOCATING}.  */
  ${OTHER_SECTIONS}
}
EOF
